#!/bin/bash
set -e
APP_NAME="dhf-agent"
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

echo "Installing ${APP_NAME}..."

# 设置可执行权限
chmod +x "${SCRIPT_DIR}/${APP_NAME}"

# 安装二进制文件
sudo cp "${SCRIPT_DIR}/${APP_NAME}" /usr/local/bin/${APP_NAME}
sudo chmod +x /usr/local/bin/${APP_NAME}

# 安装图标
sudo mkdir -p /usr/share/icons/hicolor/128x128/apps
sudo cp "${SCRIPT_DIR}/${APP_NAME}.png" /usr/share/icons/hicolor/128x128/apps/${APP_NAME}.png

# 安装 desktop 文件
sudo cp "${SCRIPT_DIR}/${APP_NAME}.desktop" /usr/share/applications/${APP_NAME}.desktop

# 更新桌面数据库
sudo update-desktop-database /usr/share/applications 2>/dev/null || true
sudo gtk-update-icon-cache /usr/share/icons/hicolor 2>/dev/null || true

echo "${APP_NAME} installed successfully!"
echo "You can now find DHF Agent in your application menu."
